package cn.ninegame.ad.demo.util;

import android.Manifest.permission;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.Build.VERSION;
import android.os.Build.VERSION_CODES;
import android.telephony.TelephonyManager;


public class AppContextHelper {
    private static Context mAppContext;

    public static void setContext(Context sContext) {
        AppContextHelper.mAppContext = sContext;
    }

    public static Context appContext() {
        return mAppContext;
    }

    public static String getVersionCode() {
        PackageManager packageManager = mAppContext.getPackageManager();
        PackageInfo packageInfo;
        String versionCode = "0";
        try {
            packageInfo = packageManager.getPackageInfo(mAppContext.getPackageName(), 0);
            versionCode = packageInfo.versionCode + "";
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return versionCode;
    }

    public static String getVersionName() {
        PackageManager packageManager = mAppContext.getPackageManager();
        PackageInfo packageInfo;
        String versionName = "unknow";
        try {
            packageInfo = packageManager.getPackageInfo(mAppContext.getPackageName(), 0);
            versionName = packageInfo.versionName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return versionName;
    }

    public static ActivityManager activityManager() {
        return (ActivityManager) appContext().getSystemService(Context.ACTIVITY_SERVICE);
    }

    public static ConnectivityManager getConnectivityManager() {
        ConnectivityManager cm = (ConnectivityManager) mAppContext.getSystemService(Context.CONNECTIVITY_SERVICE);
        return cm;
    }

    public static TelephonyManager telephonyManager() {
        return (TelephonyManager) mAppContext.getSystemService(Context.TELEPHONY_SERVICE);
    }

    public static WifiManager wifiManager() {
        return (WifiManager) mAppContext.getSystemService(Context.WIFI_SERVICE);
    }

    public static ContentResolver contentResolver() {
        return mAppContext.getContentResolver();
    }

    public static String packageName() {
        return mAppContext.getPackageName();
    }

    public static PackageManager getPackageManager() {
        return mAppContext.getPackageManager();
    }

    public static boolean hasReadPhonePermission() {
        return VERSION.SDK_INT < VERSION_CODES.M || mAppContext.checkSelfPermission(permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED;
    }
}
